"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pickTypeForName = pickTypeForName;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function pickTypeForName({
  name,
  type,
  typesByFieldName = {}
}) {
  var _typesAvailableForNam;
  const typesAvailableForName = typesByFieldName[name] || [];
  const isCurrentTypeAvailableForNewName = typesAvailableForName.includes(type);

  /* First try to keep the type if it's available for the name */
  if (isCurrentTypeAvailableForNewName) {
    return type;
  }

  /*
    If current type is not available, pick the first available type.
    If no type is available, use the current type.
  */
  return (_typesAvailableForNam = typesAvailableForName[0]) !== null && _typesAvailableForNam !== void 0 ? _typesAvailableForNam : type;
}