"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuppressionDurationSelector = SuppressionDurationSelector;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _shared_imports = require("../../../../../shared_imports");
var _types = require("../../../../common/types");
var _duration_input = require("../../duration_input");
var _fields = require("../constants/fields");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SuppressionDurationSelector({
  onlyPerTimePeriod,
  onlyPerTimePeriodReasonMessage,
  disabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "alertSuppressionDuration"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      suppressionDurationSelector: {
        path: _fields.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME
      },
      suppressionDurationValue: {
        path: `${_fields.ALERT_SUPPRESSION_DURATION_FIELD_NAME}.${_fields.ALERT_SUPPRESSION_DURATION_VALUE_FIELD_NAME}`
      },
      suppressionDurationUnit: {
        path: `${_fields.ALERT_SUPPRESSION_DURATION_FIELD_NAME}.${_fields.ALERT_SUPPRESSION_DURATION_UNIT_FIELD_NAME}`
      }
    }
  }, ({
    suppressionDurationSelector,
    suppressionDurationValue,
    suppressionDurationUnit
  }) => /*#__PURE__*/_react.default.createElement(SuppressionDurationSelectorFields, {
    suppressionDurationSelectorField: suppressionDurationSelector,
    suppressionDurationValueField: suppressionDurationValue,
    suppressionDurationUnitField: suppressionDurationUnit,
    onlyPerTimePeriod: onlyPerTimePeriod,
    onlyPerTimePeriodReasonMessage: onlyPerTimePeriodReasonMessage,
    disabled: disabled
  })));
}
const SuppressionDurationSelectorFields = /*#__PURE__*/(0, _react.memo)(function SuppressionDurationSelectorFields({
  suppressionDurationSelectorField,
  suppressionDurationValueField,
  suppressionDurationUnitField,
  onlyPerTimePeriod = false,
  onlyPerTimePeriodReasonMessage,
  disabled
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    value: durationType,
    setValue: setDurationType
  } = suppressionDurationSelectorField;
  (0, _react.useEffect)(() => {
    if (onlyPerTimePeriod && durationType !== _types.AlertSuppressionDurationType.PerTimePeriod) {
      setDurationType(_types.AlertSuppressionDurationType.PerTimePeriod);
    }
  }, [onlyPerTimePeriod, durationType, setDurationType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: disabled,
    idSelected: suppressionDurationSelectorField.value,
    options: [{
      id: _types.AlertSuppressionDurationType.PerRuleExecution,
      label: onlyPerTimePeriod ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: onlyPerTimePeriodReasonMessage
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ", i18n.ALERT_SUPPRESSION_DURATION_PER_RULE_EXECUTION_OPTION)) : i18n.ALERT_SUPPRESSION_DURATION_PER_RULE_EXECUTION_OPTION,
      disabled: onlyPerTimePeriod ? true : disabled
    }, {
      id: _types.AlertSuppressionDurationType.PerTimePeriod,
      disabled,
      label: i18n.ALERT_SUPPRESSION_DURATION_PER_TIME_PERIOD_OPTION
    }],
    onChange: id => {
      suppressionDurationSelectorField.setValue(id);
    },
    "data-test-subj": "alertSuppressionDurationOptions"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.css)`
          padding-left: ${euiTheme.size.l};
        `
  }, /*#__PURE__*/_react.default.createElement(_duration_input.DurationInput, {
    durationValueField: suppressionDurationValueField,
    durationUnitField: suppressionDurationUnitField
    // Suppression duration is also disabled suppression by rule execution is selected in radio button
    ,
    isDisabled: disabled || suppressionDurationSelectorField.value !== _types.AlertSuppressionDurationType.PerTimePeriod,
    "aria-label": i18n.ALERT_SUPPRESSION_DURATION_PER_TIME_PERIOD_OPTION,
    minimumValue: 1
  })));
});