"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSecurityDashboards = void 0;
var _react = require("react");
var _use_fetch = require("../../common/hooks/use_fetch");
var _kibana = require("../../common/lib/kibana");
var _api = require("../../common/containers/dashboards/api");
var _dashboard_context = require("../context/dashboard_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchSecurityDashboards = () => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const securityTags = (0, _dashboard_context.useSecurityTags)();
  const {
    fetch,
    data: dashboards,
    isLoading,
    error
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.SECURITY_DASHBOARDS, _api.getDashboardsByTagIds);
  (0, _react.useEffect)(() => {
    if (securityTags) {
      fetch({
        http,
        tagIds: securityTags.map(({
          id
        }) => id)
      });
    }
  }, [fetch, http, securityTags]);
  return {
    dashboards,
    isLoading,
    error
  };
};
exports.useFetchSecurityDashboards = useFetchSecurityDashboards;