"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configurationsLinks = void 0;
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants2 = require("../../common/constants");
var _translations2 = require("../app/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configurationsLinks = exports.configurationsLinks = {
  capabilities: [[`${_constants2.SECURITY_FEATURE_ID}.show`, `${_constants2.SECURITY_FEATURE_ID}.configurations`]],
  globalNavPosition: 3,
  globalSearchKeywords: [i18n.CONFIGURATIONS],
  hideTimeline: true,
  id: _constants2.SecurityPageName.configurations,
  path: _constants2.CONFIGURATIONS_PATH,
  title: _translations2.CONFIGURATIONS,
  links: [{
    id: _constants2.SecurityPageName.configurationsIntegrations,
    title: i18n.INTEGRATIONS,
    path: `${_constants2.CONFIGURATIONS_PATH}/${_constants.ConfigurationTabs.integrations}`,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.configurationsBasicRules,
    title: i18n.BASIC_RULES,
    path: `${_constants2.CONFIGURATIONS_PATH}/${_constants.ConfigurationTabs.basicRules}`,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.configurationsAiSettings,
    title: i18n.AI_SETTINGS,
    path: `${_constants2.CONFIGURATIONS_PATH}/${_constants.ConfigurationTabs.aiSettings}`,
    skipUrlState: true,
    hideTimeline: true
  }]
};