"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPreviousTimeRange = exports.getFutureTimeRange = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPreviousTimeRange = dateRange => {
  const {
    from,
    to
  } = dateRange;
  const duration = (0, _moment.default)(to).diff((0, _moment.default)(from));
  const previousStart = (0, _moment.default)(from).subtract(duration).toISOString();
  const previousEnd = (0, _moment.default)(to).subtract(duration).toISOString();
  return {
    kind: 'absolute',
    fromStr: undefined,
    toStr: undefined,
    from: previousStart,
    to: previousEnd
  };
};
exports.getPreviousTimeRange = getPreviousTimeRange;
const getFutureTimeRange = dateRange => {
  const {
    from,
    to
  } = dateRange;
  const duration = (0, _moment.default)(to).diff((0, _moment.default)(from));
  const previousStart = (0, _moment.default)(from).add(duration).toISOString();
  const previousEnd = (0, _moment.default)(to).add(duration).toISOString();
  return {
    kind: 'absolute',
    fromStr: undefined,
    toStr: undefined,
    from: previousStart,
    to: previousEnd
  };
};
exports.getFutureTimeRange = getFutureTimeRange;