"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectNotesByIdSelector = exports.selectNotesById = exports.selectNotesAsCommentsListSelector = exports.notesByIdsSelector = exports.getNotesAsCommentsList = exports.getNotes = exports.errorsSelector = void 0;
var _fp = require("lodash/fp");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectNotesById = state => state.app.notesById;
exports.selectNotesById = selectNotesById;
const getErrors = state => state.app.errors;
const getNotes = exports.getNotes = (0, _memoizeOne.default)((notesById, noteIds) => (0, _fp.keys)(notesById).reduce((acc, noteId) => {
  if (noteIds.includes(noteId)) {
    const note = notesById[noteId];
    return [...acc, note];
  }
  return acc;
}, []));
const getNotesAsCommentsList = notesById => (0, _fp.values)(notesById).map(note => {
  var _note$lastEdit;
  return {
    eventId: note.eventId,
    savedObjectId: note.saveObjectId,
    note: note.note,
    noteId: note.id,
    updated: ((_note$lastEdit = note.lastEdit) !== null && _note$lastEdit !== void 0 ? _note$lastEdit : note.created).getTime(),
    updatedBy: note.user
  };
});
exports.getNotesAsCommentsList = getNotesAsCommentsList;
const selectNotesByIdSelector = exports.selectNotesByIdSelector = (0, _reselect.createSelector)(selectNotesById, notesById => notesById);
const notesByIdsSelector = () => (0, _reselect.createSelector)(selectNotesById, notesById => notesById);
exports.notesByIdsSelector = notesByIdsSelector;
const selectNotesAsCommentsListSelector = () => (0, _reselect.createSelector)(selectNotesById, getNotesAsCommentsList);
exports.selectNotesAsCommentsListSelector = selectNotesAsCommentsListSelector;
const errorsSelector = () => (0, _reselect.createSelector)(getErrors, errors => errors);
exports.errorsSelector = errorsSelector;