"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleUpgradeTelemetryEvents = exports.ruleUpgradeSingleButtonClickEvent = exports.ruleUpgradeOpenFlyoutEvent = exports.ruleUpgradeFlyoutButtonClickEvent = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleUpgradeFlyoutButtonClickEvent = exports.ruleUpgradeFlyoutButtonClickEvent = {
  eventType: _types.RuleUpgradeEventTypes.RuleUpgradeFlyoutButtonClick,
  schema: {
    type: {
      type: 'keyword',
      _meta: {
        description: 'Click Rule Upgrade Flyout Button (update|dismiss)',
        optional: false
      }
    },
    hasMissingBaseVersion: {
      type: 'boolean',
      _meta: {
        description: 'Indicates if the rule has a missing base version',
        optional: false
      }
    }
  }
};
const ruleUpgradeSingleButtonClickEvent = exports.ruleUpgradeSingleButtonClickEvent = {
  eventType: _types.RuleUpgradeEventTypes.RuleUpgradeSingleButtonClick,
  schema: {
    hasBaseVersion: {
      type: 'boolean',
      _meta: {
        description: 'Indicates if the rule has base version',
        optional: false
      }
    }
  }
};
const ruleUpgradeOpenFlyoutEvent = exports.ruleUpgradeOpenFlyoutEvent = {
  eventType: _types.RuleUpgradeEventTypes.RuleUpgradeFlyoutOpen,
  schema: {
    hasMissingBaseVersion: {
      type: 'boolean',
      _meta: {
        description: 'Indicates if the rule has a missing base version',
        optional: false
      }
    }
  }
};
const ruleUpgradeTelemetryEvents = exports.ruleUpgradeTelemetryEvents = [ruleUpgradeFlyoutButtonClickEvent, ruleUpgradeOpenFlyoutEvent, ruleUpgradeSingleButtonClickEvent];