"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openNoteInExpandableFlyoutClickedEvent = exports.notesTelemetryEvents = exports.addNoteFromExpandableFlyoutClickedEvent = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openNoteInExpandableFlyoutClickedEvent = exports.openNoteInExpandableFlyoutClickedEvent = {
  eventType: _types.NotesEventTypes.OpenNoteInExpandableFlyoutClicked,
  schema: {
    location: {
      type: 'text',
      _meta: {
        description: 'Table ID or timeline ID',
        optional: false
      }
    }
  }
};
const addNoteFromExpandableFlyoutClickedEvent = exports.addNoteFromExpandableFlyoutClickedEvent = {
  eventType: _types.NotesEventTypes.AddNoteFromExpandableFlyoutClicked,
  schema: {
    isRelatedToATimeline: {
      type: 'boolean',
      _meta: {
        description: 'If the note was added related to a saved timeline',
        optional: false
      }
    }
  }
};
const notesTelemetryEvents = exports.notesTelemetryEvents = [openNoteInExpandableFlyoutClickedEvent, addNoteFromExpandableFlyoutClickedEvent];