"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isResponseActionsAlertAgentIdField = void 0;
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks to see if a given alert field (ex. `agent.id`) is used by Agents that have support for response actions.
 */
const isResponseActionsAlertAgentIdField = field => {
  return _constants.SUPPORTED_AGENT_ID_ALERT_FIELDS.includes(field);
};
exports.isResponseActionsAlertAgentIdField = isResponseActionsAlertAgentIdField;