"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStartTransaction = exports.getSearchTransactionName = void 0;
var _react = require("react");
var _kibana = require("../kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TRANSACTION_OPTIONS = {
  managed: true
};
const useStartTransaction = () => {
  const {
    services: {
      apm
    }
  } = (0, _kibana.useKibana)();
  const startTransaction = (0, _react.useCallback)(({
    name,
    type = 'user-interaction',
    options
  }) => {
    return apm.startTransaction(name, type, options !== null && options !== void 0 ? options : DEFAULT_TRANSACTION_OPTIONS);
  }, [apm]);
  return {
    startTransaction
  };
};
exports.useStartTransaction = useStartTransaction;
const getSearchTransactionName = timelineId => `Timeline search ${timelineId}`;
exports.getSearchTransactionName = getSearchTransactionName;