"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefetchQueries = void 0;
var _react = require("react");
var _selectors = require("../components/super_date_picker/selectors");
var _constants = require("../store/inputs/constants");
var _use_selector = require("./use_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRefetchQueries = () => {
  const getQueriesSelector = (0, _react.useMemo)(() => (0, _selectors.queriesSelector)(), []);
  const queries = (0, _use_selector.useDeepEqualSelector)(state => getQueriesSelector(state, _constants.InputsModelId.global));
  const refetchPage = (0, _react.useCallback)(() => {
    queries.forEach(q => q.refetch && q.refetch());
  }, [queries]);
  return refetchPage;
};
exports.useRefetchQueries = useRefetchQueries;