"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataTableFilters = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_selector = require("./use_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  updateShowBuildingBlockAlertsFilter,
  updateShowThreatIndicatorAlertsFilter
} = _securitysolutionDataTable.dataTableActions;
const useDataTableFilters = tableId => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const {
    showOnlyThreatIndicatorAlerts,
    showBuildingBlockAlerts
  } = (0, _use_selector.useShallowEqualSelector)(state => {
    var _additionalFilters, _getTable;
    return (_additionalFilters = ((_getTable = getTable(state, tableId)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).additionalFilters) !== null && _additionalFilters !== void 0 ? _additionalFilters : _securitysolutionDataTable.tableDefaults.additionalFilters;
  });
  const setShowBuildingBlockAlerts = (0, _react.useCallback)(value => {
    dispatch(updateShowBuildingBlockAlertsFilter({
      id: tableId,
      showBuildingBlockAlerts: value
    }));
  }, [dispatch, tableId]);
  const setShowOnlyThreatIndicatorAlerts = (0, _react.useCallback)(value => {
    dispatch(updateShowThreatIndicatorAlertsFilter({
      id: tableId,
      showOnlyThreatIndicatorAlerts: value
    }));
  }, [dispatch, tableId]);
  return {
    showBuildingBlockAlerts,
    setShowBuildingBlockAlerts,
    showOnlyThreatIndicatorAlerts,
    setShowOnlyThreatIndicatorAlerts
  };
};
exports.useDataTableFilters = useDataTableFilters;