"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateTimerangeOnPageChange = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _constants = require("../../store/inputs/constants");
var _super_date_picker = require("../../components/super_date_picker");
var _helpers = require("../../utils/global_query_string/helpers");
var _store = require("../../store");
var _inputs = require("../../store/inputs");
var _use_route_spy = require("../../utils/route/use_route_spy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Update relative time ranges when navigating between pages.
 *
 * Ex: When 'toStr' is 'now' and we navigate to a new page, it updates `to` with the present date-time.
 *
 * * It does not update the time range on the landing page.
 * * It only updates the time range when navigating to detection pages for performance reasons.
 */
const useUpdateTimerangeOnPageChange = () => {
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const previousPage = (0, _usePrevious.default)(pageName);
  const getInputSelector = (0, _react.useMemo)(() => _store.inputsSelectors.inputsSelector(), []);
  const inputState = (0, _reactRedux.useSelector)(getInputSelector);
  const {
    timerange: globalTimerange
  } = inputState.global;
  const {
    timerange: timelineTimerange
  } = inputState.timeline;
  (0, _react.useEffect)(() => {
    if (isNavigatingToDetections(pageName, previousPage)) {
      if (timelineTimerange.kind === 'relative') {
        dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
          ...timelineTimerange,
          from: (0, _super_date_picker.formatDate)(timelineTimerange.fromStr),
          to: (0, _super_date_picker.formatDate)(timelineTimerange.toStr, {
            roundUp: true
          }),
          id: _constants.InputsModelId.timeline
        }));
      }
      if (globalTimerange.kind === 'relative') {
        dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
          ...globalTimerange,
          from: (0, _super_date_picker.formatDate)(globalTimerange.fromStr),
          to: (0, _super_date_picker.formatDate)(globalTimerange.toStr, {
            roundUp: true
          }),
          id: _constants.InputsModelId.global
        }));
      }
    }
  }, [pageName, previousPage, dispatch, timelineTimerange, globalTimerange]);
};
exports.useUpdateTimerangeOnPageChange = useUpdateTimerangeOnPageChange;
const isNavigatingToDetections = (pageName, previousPage) => pageName && previousPage && previousPage !== pageName && (0, _helpers.isDetectionsPages)(pageName);