"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_NAME = exports.UNIT = exports.TOOLTIP = exports.TIME_STAMP = exports.SHOWING = exports.SCORE = exports.NETWORK_NAME = exports.JOB_ID = exports.INTERVAL_TOOLTIP = exports.INTERVAL_SHOW_ALL = exports.INTERVAL_HOUR = exports.INTERVAL_DAY = exports.INTERVAL_AUTO = exports.INTERVAL = exports.INFLUENCED_BY = exports.HOST_NAME = exports.ENTITY = exports.DETECTOR = exports.ANOMALIES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOWING = exports.SHOWING = _i18n.i18n.translate('xpack.securitySolution.anomaliesTable.table.showingDescription', {
  defaultMessage: 'Showing'
});
const ANOMALIES = exports.ANOMALIES = _i18n.i18n.translate('xpack.securitySolution.anomaliesTable.table.anomaliesDescription', {
  defaultMessage: 'Anomalies'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.anomaliesTable.table.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {anomaly} other {anomalies}}`
});
exports.UNIT = UNIT;
const TOOLTIP = exports.TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.anomaliesTable.table.anomaliesTooltip', {
  defaultMessage: 'The anomalies table is not filterable via the SIEM global KQL search.'
});
const SCORE = exports.SCORE = _i18n.i18n.translate('xpack.securitySolution.ml.table.scoreTitle', {
  defaultMessage: 'Anomaly score'
});
const HOST_NAME = exports.HOST_NAME = _i18n.i18n.translate('xpack.securitySolution.ml.table.hostNameTitle', {
  defaultMessage: 'Host name'
});
const USER_NAME = exports.USER_NAME = _i18n.i18n.translate('xpack.securitySolution.ml.table.userNameTitle', {
  defaultMessage: 'User name'
});
const INFLUENCED_BY = exports.INFLUENCED_BY = _i18n.i18n.translate('xpack.securitySolution.ml.table.influencedByTitle', {
  defaultMessage: 'Influenced by'
});
const ENTITY = exports.ENTITY = _i18n.i18n.translate('xpack.securitySolution.ml.table.entityTitle', {
  defaultMessage: 'Entity'
});
const DETECTOR = exports.DETECTOR = _i18n.i18n.translate('xpack.securitySolution.ml.table.detectorTitle', {
  defaultMessage: 'Job'
});
const NETWORK_NAME = exports.NETWORK_NAME = _i18n.i18n.translate('xpack.securitySolution.ml.table.networkNameTitle', {
  defaultMessage: 'Network IP'
});
const TIME_STAMP = exports.TIME_STAMP = _i18n.i18n.translate('xpack.securitySolution.ml.table.timestampTitle', {
  defaultMessage: 'Timestamp'
});
const JOB_ID = exports.JOB_ID = _i18n.i18n.translate('xpack.securitySolution.ml.table.jobIdFilter', {
  defaultMessage: 'Job'
});
const INTERVAL_TOOLTIP = exports.INTERVAL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalTooltip', {
  defaultMessage: 'Show only the highest severity anomaly for each interval (such as hour or day) or show all anomalies in the selected time period.'
});
const INTERVAL = exports.INTERVAL = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalLabel', {
  defaultMessage: 'Interval'
});
const INTERVAL_AUTO = exports.INTERVAL_AUTO = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalAutoOption', {
  defaultMessage: 'Auto'
});
const INTERVAL_HOUR = exports.INTERVAL_HOUR = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalHourOption', {
  defaultMessage: '1 hour'
});
const INTERVAL_DAY = exports.INTERVAL_DAY = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalDayOption', {
  defaultMessage: '1 day'
});
const INTERVAL_SHOW_ALL = exports.INTERVAL_SHOW_ALL = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalshowAllOption', {
  defaultMessage: 'Show all'
});