"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSeriesLink = void 0;
var _create_entities_from_score = require("../score/create_entities_from_score");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSeriesLink = (score, startDate, endDate) => {
  const startDateIso = new Date(startDate).toISOString();
  const endDateIso = new Date(endDate).toISOString();
  const JOB_PREFIX = `ml#/timeseriesexplorer?_g=(ml:(jobIds:!(${score.jobId}))`;
  const REFRESH_INTERVAL = `,refreshInterval:(display:Off,pause:!f,value:0),time:(from:'${startDateIso}',mode:absolute,to:'${endDateIso}'))`;
  const INTERVAL_SELECTION = `&_a=(mlSelectInterval:(display:Auto,val:auto),mlSelectSeverity:(color:%23d2e9f7,display:warning,val:0),mlTimeSeriesExplorer:(detectorIndex:0,`;
  const ENTITIES = `entities:(${(0, _create_entities_from_score.createEntitiesFromScore)(score)})))`;
  return `${JOB_PREFIX}${REFRESH_INTERVAL}${INTERVAL_SELECTION}${ENTITIES}`;
};
exports.createSeriesLink = createSeriesLink;