"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replacement = exports.replaceKqlCommasWithOrUsingRegex = exports.replaceKqlCommasWithOr = void 0;
var _rison = require("@kbn/rison");
var _rison_helpers = require("./rison_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const replacement = (match, p1, p2) => {
  const split = p2.split(',');
  const newQuery = split.reduce((accum, item, index) => {
    if (index === 0) {
      return `${p1}: "${item}"`;
    } else {
      return `${accum} or ${p1}: "${item}"`;
    }
  }, '');
  return `(${newQuery})`;
};
exports.replacement = replacement;
const replaceKqlCommasWithOrUsingRegex = expression => {
  const myRegexp = /([\w\.\-\[\]]+)\s*:\s*"(([\w\.\-\(\)\[\]]+)(,[\w\.\-\(\)\[\]]+){1,})"/g;
  return expression.replace(myRegexp, replacement);
};
exports.replaceKqlCommasWithOrUsingRegex = replaceKqlCommasWithOrUsingRegex;
const replaceKqlCommasWithOr = kqlQuery => {
  const value = (0, _rison_helpers.decodeRison)(kqlQuery);
  if ((0, _rison_helpers.isRisonObject)(value)) {
    const appQuery = value;
    if ((0, _rison_helpers.isRisonObject)(appQuery)) {
      if ((0, _rison_helpers.isRegularString)(appQuery.query)) {
        appQuery.query = replaceKqlCommasWithOrUsingRegex(appQuery.query);
        return (0, _rison.encode)(value);
      }
    }
  }
  return kqlQuery;
};
exports.replaceKqlCommasWithOr = replaceKqlCommasWithOr;