"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocalizedDateTooltip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LocalizedDateTooltip = exports.LocalizedDateTooltip = /*#__PURE__*/_react.default.memo(({
  children,
  date,
  fieldName,
  className = '',
  tooltipProps
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, (0, _extends2.default)({
  "data-test-subj": "localized-date-tool-tip",
  anchorClassName: className
}, tooltipProps, {
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "dates-container",
    direction: "column",
    gutterSize: "none"
  }, fieldName != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "field-name"
  }, fieldName)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    "data-test-subj": "humanized-relative-date",
    value: _moment.default.utc(date).toDate()
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "with-day-of-week",
    grow: false
  }, _moment.default.utc(date).local().format('llll')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "with-time-zone-offset-in-hours",
    grow: false
  }, (0, _moment.default)(date).format()))
}), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
LocalizedDateTooltip.displayName = 'LocalizedDateTooltip';