"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataProviderAnd = exports.getDataProvider = void 0;
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _helpers = require("../../../timelines/components/timeline/data_providers/helpers");
var _types = require("../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDataProvider = (field, id, value, operator = _types.IS_OPERATOR, excluded = false) => ({
  and: [],
  enabled: true,
  id: (0, _securitysolutionTGrid.escapeDataProviderId)(id),
  name: field,
  excluded,
  kqlQuery: '',
  queryMatch: {
    field,
    value,
    operator,
    displayValue: (0, _helpers.getDisplayValue)(value)
  }
});
exports.getDataProvider = getDataProvider;
const getDataProviderAnd = (field, id, value, operator = _types.IS_OPERATOR, excluded = false) => {
  const {
    and,
    ...dataProvider
  } = getDataProvider(field, id, value, operator, excluded);
  return dataProvider;
};
exports.getDataProviderAnd = getDataProviderAnd;