"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePollApi = exports.attackDiscoveryStatus = void 0;
var _react = require("react");
var uuid = _interopRequireWildcard(require("uuid"));
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _moment = _interopRequireDefault(require("moment"));
var _translations = require("../../translations");
var _helpers = require("../../helpers");
var _helpers2 = require("../../../helpers");
var _use_kibana_feature_flags = require("../../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePollApi = ({
  http,
  setApproximateFutureTime,
  toasts,
  connectorId
}) => {
  const [status, setStatus] = (0, _react.useState)(null);
  const [stats, setStats] = (0, _react.useState)(null);
  const [data, setData] = (0, _react.useState)(null);
  const timeoutIdRef = (0, _react.useRef)(null);
  const connectorIdRef = (0, _react.useRef)(undefined);
  const [didInitialFetch, setDidInitialFetch] = (0, _react.useState)(false);
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  (0, _react.useEffect)(() => {
    connectorIdRef.current = connectorId;
    setDidInitialFetch(false);
    return () => {
      connectorIdRef.current = undefined;
      // when a connectorId changes, clear timeout
      if (timeoutIdRef.current) clearTimeout(timeoutIdRef.current);
    };
  }, [connectorId]);
  const handleResponse = (0, _react.useCallback)(responseData => {
    if (connectorId == null || connectorId === '') {
      throw new Error('Invalid connector id');
    }
    setDidInitialFetch(true);
    if (responseData == null) {
      setStatus(null);
      setData(null);
      return;
    }
    setData(prevData => {
      if (responseData.updatedAt === (prevData === null || prevData === void 0 ? void 0 : prevData.updatedAt) && responseData.status === (prevData === null || prevData === void 0 ? void 0 : prevData.status) && responseData.id === (prevData === null || prevData === void 0 ? void 0 : prevData.id)) {
        // do not update if the data is the same
        // prevents unnecessary re-renders
        return prevData;
      }
      setStatus(responseData.status);
      setApproximateFutureTime((0, _moment.default)(responseData.updatedAt).add(responseData.averageIntervalMs, 'milliseconds').toDate());
      return {
        ...responseData,
        connectorId,
        attackDiscoveries: responseData.attackDiscoveries.map(attackDiscovery => {
          var _attackDiscovery$id, _attackDiscovery$enti;
          return {
            ...attackDiscovery,
            id: (_attackDiscovery$id = attackDiscovery.id) !== null && _attackDiscovery$id !== void 0 ? _attackDiscovery$id : uuid.v4(),
            detailsMarkdown: (0, _helpers2.replaceNewlineLiterals)(attackDiscovery.detailsMarkdown),
            entitySummaryMarkdown: (0, _helpers2.replaceNewlineLiterals)((_attackDiscovery$enti = attackDiscovery.entitySummaryMarkdown) !== null && _attackDiscovery$enti !== void 0 ? _attackDiscovery$enti : ''),
            summaryMarkdown: (0, _helpers2.replaceNewlineLiterals)(attackDiscovery.summaryMarkdown)
          };
        })
      };
    });
  }, [connectorId, setApproximateFutureTime]);
  const cancelAttackDiscovery = (0, _react.useCallback)(async () => {
    try {
      if (connectorId == null || connectorId === '') {
        throw new Error('Invalid connector id');
      }
      const rawResponse = await http.fetch(`/internal/elastic_assistant/attack_discovery/cancel/${connectorId}`, {
        method: 'POST',
        version: _elasticAssistantCommon.API_VERSIONS.internal.v1
      });
      const parsedResponse = _elasticAssistantCommon.AttackDiscoveryCancelResponse.safeParse(rawResponse);
      if (!parsedResponse.success) {
        throw new Error('Failed to parse the attack discovery cancel response');
      }
      handleResponse(parsedResponse.data);
    } catch (error) {
      setStatus(null);
      toasts === null || toasts === void 0 ? void 0 : toasts.addDanger(error, {
        title: _translations.ERROR_CANCELING_ATTACK_DISCOVERIES,
        text: (0, _helpers.getErrorToastText)(error)
      });
    }
  }, [connectorId, handleResponse, http, toasts]);
  const pollApi = (0, _react.useCallback)(async () => {
    try {
      if (connectorId == null || connectorId === '') {
        throw new Error('Invalid connector id');
      }
      // edge case - clearTimeout does not always work in time
      // so we need to check if the connectorId has changed
      if (connectorId !== connectorIdRef.current) {
        return;
      }
      // call the internal API to generate attack discoveries:
      const rawResponse = await http.fetch(`/internal/elastic_assistant/attack_discovery/${connectorId}`, {
        method: 'GET',
        version: _elasticAssistantCommon.API_VERSIONS.internal.v1
      });
      const parsedResponse = _elasticAssistantCommon.AttackDiscoveryGetResponse.safeParse(rawResponse);
      if (!parsedResponse.success) {
        throw new Error('Failed to parse the attack discovery GET response');
      }
      // ensure component did not unmount before setting state
      if (connectorIdRef.current) {
        var _parsedResponse$data$;
        handleResponse((_parsedResponse$data$ = parsedResponse.data.data) !== null && _parsedResponse$data$ !== void 0 ? _parsedResponse$data$ : null);
        const allStats = parsedResponse.data.stats.reduce((acc, ad) => {
          return {
            ...acc,
            newConnectorResultsCount: !ad.hasViewed && (ad.status === 'succeeded' || ad.status === 'failed') ? acc.newConnectorResultsCount + 1 : acc.newConnectorResultsCount,
            newDiscoveriesCount: !ad.hasViewed && ad.status === 'succeeded' ? acc.newDiscoveriesCount + ad.count : acc.newDiscoveriesCount
          };
        }, {
          newDiscoveriesCount: 0,
          newConnectorResultsCount: 0,
          statsPerConnector: parsedResponse.data.stats
        });
        setStats(allStats);
        if (!attackDiscoveryAlertsEnabled) {
          // poll every 5 seconds, regardless if current connector is running. Need stats object for connector dropdown stats
          timeoutIdRef.current = setTimeout(() => {
            pollApi();
          }, 5000);
        }
      }
    } catch (error) {
      setStatus(null);
      setData(null);
      toasts === null || toasts === void 0 ? void 0 : toasts.addDanger(error, {
        title: _translations.ERROR_GENERATING_ATTACK_DISCOVERIES,
        text: (0, _helpers.getErrorToastText)(error)
      });
    }
  }, [connectorId, handleResponse, http, attackDiscoveryAlertsEnabled, toasts]);
  return {
    cancelAttackDiscovery,
    didInitialFetch,
    status,
    data,
    pollApi,
    stats,
    setStatus
  };
};
exports.usePollApi = usePollApi;
const attackDiscoveryStatus = exports.attackDiscoveryStatus = {
  canceled: 'canceled',
  failed: 'failed',
  running: 'running',
  succeeded: 'succeeded'
};