"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequestBody = exports.getGenAiConfig = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// aligns with OpenAiProviderType from '@kbn/stack-connectors-plugin/common/openai/types'
var OpenAiProviderType = /*#__PURE__*/function (OpenAiProviderType) {
  OpenAiProviderType["OpenAi"] = "OpenAI";
  OpenAiProviderType["AzureAi"] = "Azure OpenAI";
  OpenAiProviderType["Other"] = "Other";
  return OpenAiProviderType;
}(OpenAiProviderType || {});
/**
 * Returns the GenAiConfig for a given ActionConnector. Note that if the connector is preconfigured,
 * the config will be undefined as the connector is neither available nor editable.
 *
 * @param connector
 */
const getGenAiConfig = connector => {
  if (!(connector !== null && connector !== void 0 && connector.isPreconfigured)) {
    const config = connector === null || connector === void 0 ? void 0 : connector.config;
    const {
      apiProvider,
      apiUrl,
      defaultModel
    } = config !== null && config !== void 0 ? config : {};
    return {
      apiProvider,
      apiUrl,
      defaultModel: apiProvider === OpenAiProviderType.AzureAi ? getAzureApiVersionParameter(apiUrl !== null && apiUrl !== void 0 ? apiUrl : '') : defaultModel
    };
  }
  return undefined; // the connector is neither available nor editable
};
exports.getGenAiConfig = getGenAiConfig;
const getAzureApiVersionParameter = url => {
  var _urlSearchParams$get;
  const urlSearchParams = new URLSearchParams(new URL(url).search);
  return (_urlSearchParams$get = urlSearchParams.get('api-version')) !== null && _urlSearchParams$get !== void 0 ? _urlSearchParams$get : undefined;
};
const getRequestBody = ({
  alertsIndexPattern,
  anonymizationFields,
  genAiConfig,
  selectedConnector,
  size,
  traceOptions
}) => {
  var _anonymizationFields$, _selectedConnector$id, _selectedConnector$ac;
  return {
    alertsIndexPattern: alertsIndexPattern !== null && alertsIndexPattern !== void 0 ? alertsIndexPattern : '',
    anonymizationFields: (_anonymizationFields$ = anonymizationFields === null || anonymizationFields === void 0 ? void 0 : anonymizationFields.data) !== null && _anonymizationFields$ !== void 0 ? _anonymizationFields$ : [],
    langSmithProject: (0, _fp.isEmpty)(traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.langSmithProject) ? undefined : traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.langSmithProject,
    langSmithApiKey: (0, _fp.isEmpty)(traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.langSmithApiKey) ? undefined : traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.langSmithApiKey,
    replacements: {},
    // no need to re-use replacements in the current implementation
    size,
    subAction: 'invokeAI',
    // non-streaming
    apiConfig: {
      connectorId: (_selectedConnector$id = selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.id) !== null && _selectedConnector$id !== void 0 ? _selectedConnector$id : '',
      actionTypeId: (_selectedConnector$ac = selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.actionTypeId) !== null && _selectedConnector$ac !== void 0 ? _selectedConnector$ac : '',
      provider: genAiConfig === null || genAiConfig === void 0 ? void 0 : genAiConfig.apiProvider,
      model: genAiConfig === null || genAiConfig === void 0 ? void 0 : genAiConfig.defaultModel
    }
  };
};
exports.getRequestBody = getRequestBody;