"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _execution_status = require("../../utils/execution_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusTextWrapperClassName = (0, _css.css)`
  width: 100%;
  display: inline-grid;
`;
const StatusBadge = exports.StatusBadge = /*#__PURE__*/_react.default.memo(({
  schedule
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!schedule.lastExecution) {
    return null;
  }
  const executionStatus = schedule.lastExecution.status;
  const executionMessage = schedule.lastExecution.message;
  const label = (0, _execution_status.getExecutionStatusLabel)(executionStatus);
  const color = (0, _execution_status.getExecutionStatusHealthColor)(executionStatus, euiTheme);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: executionMessage !== null && executionMessage !== void 0 ? executionMessage : label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    "data-test-subj": 'scheduleExecutionStatus'
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: statusTextWrapperClassName
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate"
  }, label))));
});
StatusBadge.displayName = 'StatusBadge';