"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleView = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
var _use_find_schedules = require("../schedule/logic/use_find_schedules");
var _empty_page = require("../schedule/empty_page");
var _schedules_table = require("../schedule/schedules_table");
var _create_flyout = require("../schedule/create_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useScheduleView = () => {
  const {
    services: {
      featureFlags
    }
  } = (0, _kibana.useKibana)();
  const isAttackDiscoverySchedulingEnabled = featureFlags.getBooleanValue(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ENABLED_FEATURE_FLAG, true);

  // showing / hiding the flyout:
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const openFlyout = (0, _react.useCallback)(() => setShowFlyout(true), []);
  const onClose = (0, _react.useCallback)(() => setShowFlyout(false), []);

  // TODO: add separate hook to fetch schedules stats/count
  const {
    data: {
      total
    } = {
      total: 0
    },
    isLoading: isDataLoading
  } = (0, _use_find_schedules.useFindAttackDiscoverySchedules)({
    disableToast: !isAttackDiscoverySchedulingEnabled
  });
  const scheduleView = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
      isLoading: isDataLoading,
      loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)),
      loadedContent: !total ? /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, null) : /*#__PURE__*/_react.default.createElement(_schedules_table.SchedulesTable, null)
    }), showFlyout && /*#__PURE__*/_react.default.createElement(_create_flyout.CreateFlyout, {
      onClose: onClose
    }));
  }, [isDataLoading, onClose, showFlyout, total]);
  const actionButtons = (0, _react.useMemo)(() => {
    return total ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "createNewSchedule",
      fill: true,
      onClick: openFlyout,
      size: "m",
      iconType: "plusInCircle"
    }, i18n.CREATE_NEW_SCHEDULE))) : null;
  }, [openFlyout, total]);
  return {
    scheduleView,
    actionButtons
  };
};
exports.useScheduleView = useScheduleView;