"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateAlertsStatus = void 0;
var _reactQuery = require("@tanstack/react-query");
var _update_alerts = require("../../../../../common/components/toolbar/bulk_actions/update_alerts");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_find_attack_discoveries = require("../../../use_find_attack_discoveries");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateAlertsStatus = () => {
  const {
    addError,
    addSuccess,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const invalidateFindAttackDiscoveries = (0, _use_find_attack_discoveries.useInvalidateFindAttackDiscoveries)();
  return (0, _reactQuery.useMutation)(({
    ids,
    kibanaAlertWorkflowStatus
  }) => (0, _update_alerts.updateAlertStatus)({
    status: kibanaAlertWorkflowStatus,
    signalIds: ids
  }), {
    onSuccess: (data, variables) => {
      const {
        ids,
        kibanaAlertWorkflowStatus
      } = variables;
      const {
        updated,
        version_conflicts
      } = data; // eslint-disable-line @typescript-eslint/naming-convention

      const alertsCount = ids.length; // total alerts
      const allAlertsUpdated = updated === alertsCount;
      invalidateFindAttackDiscoveries();
      if (allAlertsUpdated) {
        addSuccess(i18n.SUCCESSFULLY_MARKED_ALERTS({
          updated,
          kibanaAlertWorkflowStatus
        }));
      } else if (version_conflicts != null && version_conflicts > 0) {
        addWarning(i18n.UPDATED_ALERTS_WITH_VERSION_CONFLICTS({
          kibanaAlertWorkflowStatus,
          updated,
          versionConflicts: version_conflicts
        }));
      } else {
        addWarning(i18n.PARTIALLY_UPDATED_ALERTS({
          alertsCount,
          kibanaAlertWorkflowStatus,
          updated
        }));
      }
    },
    onError: error => {
      addError(error, {
        title: i18n.ERROR_UPDATING_ALERTS
      });
    }
  });
};
exports.useUpdateAlertsStatus = useUpdateAlertsStatus;