"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Summary = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _selected_actions = require("./selected_actions");
var _summary_count = require("./summary_count");
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SummaryComponent = ({
  alertsCount,
  attackDiscoveriesCount,
  isLoading = false,
  lastUpdated,
  onToggleShowAnonymized,
  refetchFindAttackDiscoveries,
  selectedAttackDiscoveries,
  selectedConnectorAttackDiscoveries,
  setSelectedAttackDiscoveries,
  showAnonymized
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "summary",
    justifyContent: "spaceBetween",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_summary_count.SummaryCount, {
    alertsCount: alertsCount,
    attackDiscoveriesCount: attackDiscoveriesCount,
    lastUpdated: lastUpdated
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_selected_actions.SelectedActions, {
    refetchFindAttackDiscoveries: refetchFindAttackDiscoveries,
    selectedConnectorAttackDiscoveries: selectedConnectorAttackDiscoveries,
    selectedAttackDiscoveries: selectedAttackDiscoveries,
    setSelectedAttackDiscoveries: setSelectedAttackDiscoveries
  })), isLoading && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    css: (0, _react.css)`
                  margin-left: ${euiTheme.size.s};
                `,
    size: "s"
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
    checked: showAnonymized,
    compressed: true,
    "data-test-subj": "toggleAnonymized",
    label: _translations.SHOW_ANONYMIZED_LABEL,
    onChange: onToggleShowAnonymized
  })));
};
SummaryComponent.displayName = 'Summary';
const Summary = exports.Summary = /*#__PURE__*/_react2.default.memo(SummaryComponent);