"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyStates = void 0;
var _react = _interopRequireDefault(require("react"));
var _failure = require("./failure");
var _empty_prompt = require("./empty_prompt");
var _helpers = require("../../helpers");
var _no_alerts = require("./no_alerts");
var _welcome = require("./welcome");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyStatesComponent = ({
  aiConnectorsCount,
  alertsContextCount,
  attackDiscoveriesCount,
  connectorId,
  failureReason,
  isLoading,
  onGenerate,
  upToAlertsCount
}) => {
  const isDisabled = connectorId == null;

  // Return null when loading or when attack discoveries are present
  if (isLoading || attackDiscoveriesCount > 0) {
    return null;
  }
  if ((0, _helpers.showWelcomePrompt)({
    aiConnectorsCount,
    isLoading
  })) {
    return /*#__PURE__*/_react.default.createElement(_welcome.Welcome, null);
  }
  if ((0, _helpers.showFailurePrompt)({
    connectorId,
    failureReason,
    isLoading
  })) {
    return /*#__PURE__*/_react.default.createElement(_failure.Failure, {
      failureReason: failureReason
    });
  }
  if ((0, _helpers.showNoAlertsPrompt)({
    alertsContextCount,
    connectorId,
    isLoading
  })) {
    return /*#__PURE__*/_react.default.createElement(_no_alerts.NoAlerts, {
      isLoading: isLoading,
      isDisabled: isDisabled,
      onGenerate: onGenerate
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "emptyStates"
  }, /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    aiConnectorsCount: aiConnectorsCount,
    alertsCount: upToAlertsCount,
    attackDiscoveriesCount: attackDiscoveriesCount,
    isDisabled: isDisabled,
    isLoading: isLoading,
    onGenerate: onGenerate
  }));
};
const EmptyStates = exports.EmptyStates = /*#__PURE__*/_react.default.memo(EmptyStatesComponent);