"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTab = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _wrapper = require("./ai_for_soc/wrapper");
var _kibana = require("../../../../../../common/lib/kibana");
var _common = require("../../../../../../../common");
var _alerts_table = require("../../../../../../detections/components/alerts_table");
var _columns = require("../../../../../../detections/configurations/security_solution_detections/columns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsTabComponent = ({
  attackDiscovery,
  replacements
}) => {
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;

  // TODO We shouldn't have to check capabilities here, this should be done at a much higher level.
  //  https://github.com/elastic/kibana/issues/218731
  //  For the AI for SOC we need to show the Alert summary page alerts table
  const AIForSOC = capabilities[_common.SECURITY_FEATURE_ID].configurations;
  const originalAlertIds = (0, _react.useMemo)(() => (0, _elasticAssistantCommon.getOriginalAlertIds)({
    alertIds: attackDiscovery.alertIds,
    replacements
  }), [attackDiscovery, replacements]);
  const alertIdsQuery = (0, _react.useMemo)(() => ({
    ids: {
      values: originalAlertIds
    }
  }), [originalAlertIds]);
  const id = (0, _react.useMemo)(() => `attack-discovery-alerts-${attackDiscovery.id}`, [attackDiscovery.id]);

  // add workflow_status as the 2nd column in the table:
  const columns = (0, _react.useMemo)(() => {
    const defaultColumns = (0, _columns.getColumns)();
    return [...defaultColumns.slice(0, 1), {
      columnHeaderType: 'not-filtered',
      id: 'kibana.alert.workflow_status'
    }, ...defaultColumns.slice(1)];
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alertsTab"
  }, AIForSOC ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "ai4dsoc-alerts-table"
  }, /*#__PURE__*/_react.default.createElement(_wrapper.AiForSOCAlertsTab, {
    id: id,
    query: alertIdsQuery
  })) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "detection-engine-alerts-table"
  }, /*#__PURE__*/_react.default.createElement(_alerts_table.DetectionEngineAlertsTable, {
    columns: columns,
    id: id,
    tableType: _securitysolutionDataTable.TableId.alertsOnCasePage,
    ruleTypeIds: _securitysolutionRules.SECURITY_SOLUTION_RULE_TYPE_IDS,
    query: alertIdsQuery,
    showAlertStatusWithFlapping: false
  })));
};
AlertsTabComponent.displayName = 'AlertsTab';
const AlertsTab = exports.AlertsTab = /*#__PURE__*/_react.default.memo(AlertsTabComponent);