"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECONDS_ABBREVIATION = exports.AVERAGE_TIME_IS_CALCULATED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AVERAGE_TIME_IS_CALCULATED = intervals => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.loadingCallout.countdown.lastTimesPopover.aiIsCurrentlyAnalyzing', {
  defaultMessage: 'Remaining time is based on the average speed of the last {intervals} {intervals, plural, =1 {time} other {times}} the same connector generated results.',
  values: {
    intervals
  }
});
exports.AVERAGE_TIME_IS_CALCULATED = AVERAGE_TIME_IS_CALCULATED;
const SECONDS_ABBREVIATION = exports.SECONDS_ABBREVIATION = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.loadingCallout.countdown.lastTimesPopover.secondsAbbreviationLabel', {
  defaultMessage: 's' // short for seconds
});