"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimerPrefix = exports.getAverageIntervalSeconds = exports.MAX_SECONDS_BADGE_WIDTH = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_SECONDS_BADGE_WIDTH = exports.MAX_SECONDS_BADGE_WIDTH = 128; // px

const getAverageIntervalSeconds = intervals => {
  const intervalSeconds = intervals.map(interval => interval.durationMs / 1000);
  if (intervalSeconds.length === 0) {
    return 0;
  }
  const average = intervalSeconds.reduce((acc, seconds) => acc + seconds, 0) / intervalSeconds.length;
  return Math.trunc(average);
};
exports.getAverageIntervalSeconds = getAverageIntervalSeconds;
const getTimerPrefix = approximateFutureTime => {
  if (approximateFutureTime == null) {
    return _translations.APPROXIMATE_TIME_REMAINING;
  }
  const now = (0, _moment.default)();
  return (0, _moment.default)(approximateFutureTime).isSameOrAfter(now) ? _translations.APPROXIMATE_TIME_REMAINING : _translations.ABOVE_THE_AVERAGE_TIME;
};
exports.getTimerPrefix = getTimerPrefix;