"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPromptContexts = exports.PROMPT_CONTEXT_EVENT_CATEGORY = exports.PROMPT_CONTEXT_DETECTION_RULES_CATEGORY = exports.PROMPT_CONTEXT_ALERT_CATEGORY = exports.DATA_QUALITY_DASHBOARD_CATEGORY = void 0;
var i18nDataQuality = _interopRequireWildcard(require("@kbn/ecs-data-quality-dashboard"));
var i18n = _interopRequireWildcard(require("./translations"));
var i18nDetections = _interopRequireWildcard(require("../../../detection_engine/common/translations"));
var i18nEventDetails = _interopRequireWildcard(require("../../../common/components/event_details/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROMPT_CONTEXT_ALERT_CATEGORY = exports.PROMPT_CONTEXT_ALERT_CATEGORY = 'alert';
const PROMPT_CONTEXT_EVENT_CATEGORY = exports.PROMPT_CONTEXT_EVENT_CATEGORY = 'event';
const PROMPT_CONTEXT_DETECTION_RULES_CATEGORY = exports.PROMPT_CONTEXT_DETECTION_RULES_CATEGORY = 'detection-rules';
const DATA_QUALITY_DASHBOARD_CATEGORY = exports.DATA_QUALITY_DASHBOARD_CATEGORY = 'data-quality-dashboard';

/**
 * Global list of PromptContexts intended to be used throughout Security Solution.
 * Useful if wanting to see all available PromptContexts in one place, or if needing
 * a unique set of categories to reference since the PromptContexts available on
 * useAssistantContext are dynamic (not globally registered).
 */
const getPromptContexts = prompts => ({
  /**
   * Alert summary view context, made available on the alert details flyout
   */
  [PROMPT_CONTEXT_ALERT_CATEGORY]: {
    category: PROMPT_CONTEXT_ALERT_CATEGORY,
    suggestedUserPrompt: prompts[PROMPT_CONTEXT_ALERT_CATEGORY],
    description: i18nEventDetails.ALERT_SUMMARY_CONTEXT_DESCRIPTION(i18n.VIEW),
    tooltip: i18nEventDetails.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP
  },
  /**
   * Event summary view context, made available from Timeline events
   */
  [PROMPT_CONTEXT_EVENT_CATEGORY]: {
    category: PROMPT_CONTEXT_EVENT_CATEGORY,
    suggestedUserPrompt: prompts[PROMPT_CONTEXT_EVENT_CATEGORY],
    description: i18nEventDetails.EVENT_SUMMARY_CONTEXT_DESCRIPTION(i18n.VIEW),
    tooltip: i18nEventDetails.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP
  },
  /**
   * Data Quality dashboard context, made available on the Data Quality dashboard
   */
  [DATA_QUALITY_DASHBOARD_CATEGORY]: {
    category: DATA_QUALITY_DASHBOARD_CATEGORY,
    suggestedUserPrompt: prompts[DATA_QUALITY_DASHBOARD_CATEGORY],
    description: i18nDataQuality.DATA_QUALITY_PROMPT_CONTEXT_PILL(i18n.INDEX),
    tooltip: i18nDataQuality.DATA_QUALITY_PROMPT_CONTEXT_PILL_TOOLTIP
  },
  /**
   * Detection Rules context, made available on the Rule Management page when rules are selected
   */
  [PROMPT_CONTEXT_DETECTION_RULES_CATEGORY]: {
    category: PROMPT_CONTEXT_DETECTION_RULES_CATEGORY,
    suggestedUserPrompt: prompts[PROMPT_CONTEXT_DETECTION_RULES_CATEGORY],
    description: i18nDetections.RULE_MANAGEMENT_CONTEXT_DESCRIPTION,
    tooltip: i18nDetections.RULE_MANAGEMENT_CONTEXT_TOOLTIP
  }
});
exports.getPromptContexts = getPromptContexts;