"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleResourceIdentifier = exports.ResourceIdentifier = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _splunk = require("./splunk");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleResourceIdentifiers = {
  splunk: _splunk.splResourceIdentifiers
};
const getRuleResourceIdentifier = vendor => {
  return ruleResourceIdentifiers[vendor];
};
exports.getRuleResourceIdentifier = getRuleResourceIdentifier;
class ResourceIdentifier {
  constructor(vendor) {
    (0, _defineProperty2.default)(this, "identifiers", void 0);
    // The constructor may need query_language as an argument for other vendors
    this.identifiers = ruleResourceIdentifiers[vendor];
  }
  fromOriginalRule(originalRule) {
    return this.identifiers.fromOriginalRule(originalRule);
  }
  fromResource(resource) {
    return this.identifiers.fromResource(resource);
  }
  fromOriginalRules(originalRules) {
    const lookups = new Set();
    const macros = new Set();
    originalRules.forEach(rule => {
      const resources = this.identifiers.fromOriginalRule(rule);
      resources.forEach(resource => {
        if (resource.type === 'macro') {
          macros.add(resource.name);
        } else if (resource.type === 'lookup') {
          lookups.add(resource.name);
        }
      });
    });
    return [...Array.from(macros).map(name => ({
      type: 'macro',
      name
    })), ...Array.from(lookups).map(name => ({
      type: 'lookup',
      name
    }))];
  }
  fromResources(resources) {
    const lookups = new Set();
    const macros = new Set();
    resources.forEach(resource => {
      this.identifiers.fromResource(resource).forEach(identifiedResource => {
        if (identifiedResource.type === 'macro') {
          macros.add(identifiedResource.name);
        } else if (identifiedResource.type === 'lookup') {
          lookups.add(identifiedResource.name);
        }
      });
    });
    return [...Array.from(macros).map(name => ({
      type: 'macro',
      name
    })), ...Array.from(lookups).map(name => ({
      type: 'lookup',
      name
    }))];
  }
}
exports.ResourceIdentifier = ResourceIdentifier;