"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMissingRiskEnginePrivileges = exports.getMissingIndexPrivileges = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMissingIndexPrivileges = (privileges, required = ['read', 'write']) => {
  const missingIndexPrivileges = [];
  if (!privileges) {
    return missingIndexPrivileges;
  }
  for (const [indexName, defaultRequiredPrivileges] of Object.entries(_constants.RISK_ENGINE_REQUIRED_ES_INDEX_PRIVILEGES)) {
    const missingPrivileges = (required || defaultRequiredPrivileges).filter(privilege => !privileges[indexName][privilege]);
    if (missingPrivileges.length) {
      missingIndexPrivileges.push([indexName, missingPrivileges]);
    }
  }
  return missingIndexPrivileges;
};
exports.getMissingIndexPrivileges = getMissingIndexPrivileges;
const getMissingRiskEnginePrivileges = (privileges, required) => {
  const missingIndexPrivileges = getMissingIndexPrivileges(privileges.elasticsearch.index, required);
  const missingClusterPrivileges = _constants.RISK_ENGINE_REQUIRED_ES_CLUSTER_PRIVILEGES.filter(privilege => {
    var _privileges$elasticse;
    return !((_privileges$elasticse = privileges.elasticsearch.cluster) !== null && _privileges$elasticse !== void 0 && _privileges$elasticse[privilege]);
  });
  return {
    indexPrivileges: missingIndexPrivileges,
    clusterPrivileges: missingClusterPrivileges
  };
};
exports.getMissingRiskEnginePrivileges = getMissingRiskEnginePrivileges;