"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.user_search_term = exports.status = exports.signal_ids = exports.saved_id = exports.savedIdOrUndefined = exports.privilege = exports.indexRecord = exports.file_name = exports.exclude_export_details = exports.alert_tags = exports.alert_tag_ids = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

const file_name = exports.file_name = _zod.z.string();
const exclude_export_details = exports.exclude_export_details = _zod.z.boolean();
const saved_id = exports.saved_id = _zod.z.string();
const savedIdOrUndefined = exports.savedIdOrUndefined = saved_id.optional();
const status = exports.status = _zod.z.enum(['open', 'closed', 'acknowledged', 'in-progress']);
const signal_ids = exports.signal_ids = _zod.z.array(_zod.z.string());
const alert_tag_ids = exports.alert_tag_ids = _zod.z.array(_zod.z.string());
const indexRecord = exports.indexRecord = _zod.z.record(_zod.z.string(), _zod.z.object({
  all: _zod.z.boolean(),
  maintenance: _zod.z.boolean(),
  read: _zod.z.boolean(),
  create_index: _zod.z.boolean(),
  index: _zod.z.boolean(),
  monitor: _zod.z.boolean(),
  delete: _zod.z.boolean(),
  manage: _zod.z.boolean(),
  delete_index: _zod.z.boolean(),
  create_doc: _zod.z.boolean(),
  view_index_metadata: _zod.z.boolean(),
  create: _zod.z.boolean(),
  write: _zod.z.boolean()
}));
const privilege = exports.privilege = _zod.z.object({
  username: _zod.z.string(),
  has_all_requested: _zod.z.boolean(),
  cluster: _zod.z.object({
    monitor_ml: _zod.z.boolean(),
    manage_index_templates: _zod.z.boolean(),
    monitor_transform: _zod.z.boolean(),
    manage_security: _zod.z.boolean(),
    manage_own_api_key: _zod.z.boolean(),
    all: _zod.z.boolean(),
    monitor: _zod.z.boolean(),
    manage: _zod.z.boolean(),
    manage_transform: _zod.z.boolean(),
    manage_ml: _zod.z.boolean(),
    manage_pipeline: _zod.z.boolean()
  }),
  index: indexRecord,
  is_authenticated: _zod.z.boolean(),
  has_encryption_key: _zod.z.boolean()
});
const alert_tags = exports.alert_tags = _zod.z.object({
  tags_to_add: _zod.z.array(_zod.z.string()),
  tags_to_remove: _zod.z.array(_zod.z.string())
});
const user_search_term = exports.user_search_term = _zod.z.string();