"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdWithCardinality = exports.ThresholdValue = exports.ThresholdNormalized = exports.ThresholdFieldNormalized = exports.ThresholdField = exports.ThresholdCardinality = exports.ThresholdAlertSuppression = exports.Threshold = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Threshold Rule Attributes
 *   version: not applicable
 */

/**
 * The field on which the cardinality is applied.
 */

const ThresholdCardinality = exports.ThresholdCardinality = _zod.z.array(_zod.z.object({
  /**
   * The field on which to calculate and compare the cardinality.
   */
  field: _zod.z.string(),
  /**
   * The threshold value from which an alert is generated based on unique number of values of cardinality.field.
   */
  value: _zod.z.number().int().min(0)
}));

/**
 * The threshold value from which an alert is generated.
 */

const ThresholdValue = exports.ThresholdValue = _zod.z.number().int().min(1);

/**
 * The field on which the threshold is applied. If you specify an empty array ([]), alerts are generated when the query returns at least the number of results specified in the value field.
 */

const ThresholdField = exports.ThresholdField = _zod.z.union([_zod.z.string(), _zod.z.array(_zod.z.string())]);

/**
 * Field to aggregate on
 */

const ThresholdFieldNormalized = exports.ThresholdFieldNormalized = _zod.z.array(_zod.z.string());
const Threshold = exports.Threshold = _zod.z.object({
  field: ThresholdField,
  value: ThresholdValue,
  cardinality: ThresholdCardinality.optional()
});
const ThresholdNormalized = exports.ThresholdNormalized = _zod.z.object({
  field: ThresholdFieldNormalized,
  value: ThresholdValue,
  cardinality: ThresholdCardinality.optional()
});
const ThresholdWithCardinality = exports.ThresholdWithCardinality = _zod.z.object({
  field: ThresholdFieldNormalized,
  value: ThresholdValue,
  cardinality: ThresholdCardinality
});

/**
 * Defines alert suppression configuration.
 */

const ThresholdAlertSuppression = exports.ThresholdAlertSuppression = _zod.z.object({
  duration: _common_attributes.AlertSuppressionDuration
});