"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryUpsellingPageESS = void 0;
var _eui = require("@elastic/eui");
var _attack_discovery = require("@kbn/security-solution-upselling/pages/attack_discovery");
var _react = _interopRequireWildcard(require("react"));
var _upgrade_actions = require("./upgrade_actions");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component passes self-managed-specific upgrade actions and `i18n` to
 * the platform agnostic `AttackDiscoveryUpsellingPage` component.
 */
const AttackDiscoveryUpsellingPageESSComponent = () => {
  const actions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "essActions",
    justifyContent: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_upgrade_actions.UpgradeActions, null))), []);
  return /*#__PURE__*/_react.default.createElement(_attack_discovery.AttackDiscoveryUpsellingPage, {
    actions: actions,
    availabilityMessage: i18n.AVAILABILITY_MESSAGE,
    upgradeMessage: i18n.UPGRADE_MESSAGE
  });
};
AttackDiscoveryUpsellingPageESSComponent.displayName = 'AttackDiscoveryUpsellingPageESS';
const AttackDiscoveryUpsellingPageESS = exports.AttackDiscoveryUpsellingPageESS = /*#__PURE__*/_react.default.memo(AttackDiscoveryUpsellingPageESSComponent);