"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteUsers = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmDeleteUsers = ({
  usernames,
  onCancel,
  onSuccess
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const [state, deleteUsers] = (0, _useAsyncFn.default)(async () => {
    for (const username of usernames) {
      try {
        await new _.UserAPIClient(services.http).deleteUser(username);
        services.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.successMessage', {
          defaultMessage: "Deleted user ''{username}''",
          values: {
            username
          }
        }));
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      } catch (error) {
        var _body;
        services.notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.errorMessage', {
            defaultMessage: "Could not delete user ''{username}''",
            values: {
              username
            }
          }),
          text: ((_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || error.message
        });
      }
    }
  }, [services.http]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    role: "dialog",
    title: _i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.title', {
      defaultMessage: "Delete {count, plural, one{user ''{username}''} other{{count} users}}?",
      values: {
        count: usernames.length,
        username: usernames[0]
      }
    }),
    onCancel: onCancel,
    onConfirm: deleteUsers,
    cancelButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.confirmButton', {
      defaultMessage: '{isLoading, select, true{Deleting {count, plural, one{user} other{users}}…} other{Delete {count, plural, one{user} other{users}}}}',
      values: {
        count: usernames.length,
        isLoading: state.loading
      }
    }),
    buttonColor: "danger",
    isLoading: state.loading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.confirmDeleteUsers.description",
    defaultMessage: "{count, plural, one{This user} other{These users}} will be permanently deleted and access to Elastic removed{count, plural, one{.} other{:}}",
    values: {
      count: usernames.length
    }
  })), usernames.length > 1 && /*#__PURE__*/_react.default.createElement("ul", null, usernames.map(username => /*#__PURE__*/_react.default.createElement("li", {
    key: username
  }, username))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.confirmDelete.cannotUndoWarning",
    defaultMessage: "You can't recover deleted users."
  }))));
};
exports.ConfirmDeleteUsers = ConfirmDeleteUsers;