"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../../lib");
var _shard_details_tree = require("./shard_details_tree");
var _percentage_badge = require("../../percentage_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasVisibleOperation = ops => {
  for (const op of ops) {
    var _op$children;
    if (op.visible) {
      return true;
    }
    if ((_op$children = op.children) !== null && _op$children !== void 0 && _op$children.length && hasVisibleOperation(op.children)) {
      return true;
    }
  }
  return false;
};
const ShardDetails = ({
  index,
  shard,
  operations
}) => {
  const {
    relative,
    time
  } = shard;
  const [shardVisibility, setShardVisibility] = (0, _react.useState)(() => hasVisibleOperation(operations.map(op => {
    var _op$treeRoot;
    return (_op$treeRoot = op.treeRoot) !== null && _op$treeRoot !== void 0 ? _op$treeRoot : op;
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "prfDevTool__profileTree__shard__header-flex-item"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    className: "prfDevTool__profileTree__shardDetails",
    onClick: () => setShardVisibility(!shardVisibility),
    "data-test-subj": "openCloseShardDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: shardVisibility ? 'arrowDown' : 'arrowRight'
  }), "[", shard.id[0], "][", shard.id[2], "]")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "prfDevTool__profileTree__shard__header-flex-item"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "prfDevTool__shardDetails--dim"
  }, /*#__PURE__*/_react.default.createElement(_percentage_badge.PercentageBadge, {
    timePercentage: String(relative),
    label: (0, _lib.msToPretty)(time, 3),
    valueType: 'time'
  })))), shardVisibility ? operations.map((data, idx) => /*#__PURE__*/_react.default.createElement(_shard_details_tree.ShardDetailTree, {
    key: idx,
    index: index,
    shard: shard,
    data: data
  })) : null);
};
exports.ShardDetails = ShardDetails;