"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePutSynonymsRule = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePutSynonymsRule = (onSuccess, onError) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useMutation)(async ({
    synonymsSetId,
    ruleId,
    synonyms
  }) => {
    return await http.put(`/internal/search_synonyms/synonyms/${synonymsSetId}/${ruleId}`, {
      body: JSON.stringify({
        synonyms
      })
    });
  }, {
    onSuccess: (_, {
      ruleId
    }) => {
      var _notifications$toasts;
      queryClient.invalidateQueries(['synonyms-sets-fetch']);
      queryClient.invalidateQueries(['synonyms-rule-fetch']);
      notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.searchSynonyms.putSynonymsRuleSuccess', {
          defaultMessage: 'Synonyms rule {ruleId} updated',
          values: {
            ruleId
          }
        })
      });
      if (onSuccess) {
        onSuccess();
      }
    },
    onError: error => {
      if (onError) {
        onError(error.body.message);
      } else {
        var _notifications$toasts2;
        notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts2 = notifications.toasts) === null || _notifications$toasts2 === void 0 ? void 0 : _notifications$toasts2.addError(new Error(error.body.message), {
          title: _i18n.i18n.translate('xpack.searchSynonyms.putSynonymsRuleError', {
            defaultMessage: 'Error updating synonyms rule'
          }),
          toastMessage: error.body.message
        });
      }
    }
  });
};
exports.usePutSynonymsRule = usePutSynonymsRule;