"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePutRuleset = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _api_routes = require("../../common/api_routes");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePutRuleset = (onSuccess, onConflictError) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    services: {
      http,
      notifications,
      application
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useMutation)(async ({
    rulesetId,
    forceWrite,
    rules
  }) => {
    return await http.put(`/internal/search_query_rules/ruleset/${rulesetId}`, {
      query: {
        forceWrite
      },
      ...(rules ? {
        body: JSON.stringify({
          rules
        })
      } : {})
    });
  }, {
    onSuccess: (_, {
      rulesetId
    }) => {
      var _notifications$toasts;
      queryClient.invalidateQueries({
        queryKey: [_constants.QUERY_RULES_QUERY_RULESET_FETCH_KEY]
      });
      queryClient.invalidateQueries({
        queryKey: [_constants.QUERY_RULES_SETS_QUERY_KEY]
      });
      queryClient.invalidateQueries({
        queryKey: [_constants.QUERY_RULES_QUERY_RULESET_EXISTS_KEY]
      });
      notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.queryRules.putRulesetSuccess', {
          defaultMessage: 'Ruleset added'
        })
      });
      if (onSuccess) {
        onSuccess();
      }
      application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/ruleset/${rulesetId}`));
    },
    onError: error => {
      if (onConflictError && error.body.statusCode === 409) {
        onConflictError(error.body);
      } else {
        var _notifications$toasts2;
        notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts2 = notifications.toasts) === null || _notifications$toasts2 === void 0 ? void 0 : _notifications$toasts2.addError(new Error(error.body.message), {
          title: _i18n.i18n.translate('xpack.queryRules.putRulesetError', {
            defaultMessage: 'Error putting ruleset'
          }),
          toastMessage: error.body.message
        });
      }
    }
  });
};
exports.usePutRuleset = usePutRuleset;