"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExcludePinDocumentButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExcludePinDocumentButton = ({
  documentCount,
  addNewAction,
  pinType
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutButton",
    iconType: "plusInCircle",
    color: documentCount === 0 ? 'primary' : 'text',
    size: "s",
    onClick: addNewAction,
    fill: documentCount === 0
  }, pinType === 'pinned' ? documentCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addPinnedDocumentButton",
    defaultMessage: "Pin document"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addPinnedDocumentButtonMore",
    defaultMessage: "Pin 1 more document"
  }) : documentCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addExcludedDocumentButton",
    defaultMessage: "Exclude document"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addExcludedDocumentButtonMore",
    defaultMessage: "Exclude 1 more document"
  }));
};
exports.ExcludePinDocumentButton = ExcludePinDocumentButton;