"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserProfile = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUserProfile = () => {
  const {
    security
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(['useGetCurrentUserProfile'], async () => {
    return security.userProfiles.getCurrent({
      dataPath: 'avatar'
    });
  }, {
    retry: false,
    staleTime: Infinity
  }).data;
};
exports.useUserProfile = useUserProfile;