"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../types");
var _assistant_message = require("./assistant_message");
var _system_message = require("./system_message");
var _user_message = require("./user_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapRoleToMessageComponent = {
  [_types.MessageRole.system]: message => /*#__PURE__*/_react.default.createElement(_system_message.SystemMessage, {
    content: message.content
  }),
  [_types.MessageRole.user]: message => /*#__PURE__*/_react.default.createElement(_user_message.UserMessage, {
    content: message.content,
    createdAt: message.createdAt
  }),
  [_types.MessageRole.assistant]: message => /*#__PURE__*/_react.default.createElement(_assistant_message.AssistantMessage, {
    message: message
  })
};
const MessageList = ({
  messages
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
  gutterSize: "m"
}, messages.map(message => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
  key: message.id
}, mapRoleToMessageComponent[message.role](message))));
exports.MessageList = MessageList;