"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectionPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectionPanel = ({
  description,
  id,
  isSelected,
  title,
  onClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `console-embedded-notebook-select-btn-${id}`,
    "data-telemdata-telemetry-id": `console-embedded-notebook-select-btn-${id}`,
    onClick: () => onClick(id),
    color: isSelected ? 'primary' : 'subdued',
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: euiTheme.colors.primaryText
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: isSelected ? euiTheme.colors.primaryText : 'subdued'
  }, /*#__PURE__*/_react.default.createElement("p", null, description))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }));
};
exports.SelectionPanel = SelectionPanel;