"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchLabsButtonPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchLabsButtonPanel = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: "https://github.com/elastic/elasticsearch-labs/tree/main/notebooks",
    target: "_blank",
    iconSide: "right",
    iconType: "popout",
    "data-test-subj": "console-notebooks-search-labs-btn",
    "data-telemetry-id": "console-notebooks-search-labs-btn"
  }, _i18n.i18n.translate('xpack.searchNotebooks.searchLabsLink', {
    defaultMessage: 'Browse all our notebooks'
  }))));
};
exports.SearchLabsButtonPanel = SearchLabsButtonPanel;