"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditInferenceFlyout = void 0;
var _inference_flyout_wrapper = require("@kbn/inference-endpoint-ui-common/src/components/inference_flyout_wrapper");
var _react = _interopRequireWildcard(require("react"));
var _objectUtils = require("@kbn/object-utils");
var _use_kibana = require("../../hooks/use_kibana");
var _use_inference_endpoints = require("../../hooks/use_inference_endpoints");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditInferenceFlyout = ({
  onFlyoutClose,
  selectedInferenceEndpoint
}) => {
  const {
    services: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    refetch
  } = (0, _use_inference_endpoints.useQueryInferenceEndpoints)();
  const onEditSuccess = (0, _react.useCallback)(() => {
    refetch();
  }, [refetch]);
  const inferenceEndpoint = {
    config: {
      inferenceId: selectedInferenceEndpoint.inference_id,
      taskType: selectedInferenceEndpoint.task_type,
      provider: selectedInferenceEndpoint.service,
      providerConfig: (0, _objectUtils.flattenObject)(selectedInferenceEndpoint.service_settings)
    },
    secrets: {
      providerSecrets: {}
    }
  };
  return /*#__PURE__*/_react.default.createElement(_inference_flyout_wrapper.InferenceFlyoutWrapper, {
    onFlyoutClose: onFlyoutClose,
    http: http,
    toasts: toasts,
    isEdit: true,
    onSubmitSuccess: onEditSuccess,
    inferenceEndpoint: inferenceEndpoint
  });
};
exports.EditInferenceFlyout = EditInferenceFlyout;