"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navigateToIndexDetails = void 0;
var _reactRouterDom = require("react-router-dom");
var _routes = require("../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_DETAILS_FULL_PATH = `${_routes.INDICES_APP_BASE}${_routes.SEARCH_INDICES_DETAILS_PATH}`;
function getIndexDetailsPath(http, indexName) {
  return http.basePath.prepend((0, _reactRouterDom.generatePath)(INDEX_DETAILS_FULL_PATH, {
    indexName
  }));
}
const navigateToIndexDetails = (application, http, indexName) => {
  application.navigateToUrl(getIndexDetailsPath(http, indexName));
};
exports.navigateToIndexDetails = navigateToIndexDetails;