"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndicesRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _use_kibana = require("../hooks/use_kibana");
var _routes = require("../routes");
var _details_page = require("./indices/details_page");
var _create_index_page = require("./create_index/create_index_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndicesRouter = () => {
  const {
    application,
    history
  } = (0, _use_kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [_routes.SEARCH_INDICES_DETAILS_TABS_PATH, _routes.SEARCH_INDICES_DETAILS_PATH]
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDICES_DETAILS_TABS_PATH,
    component: _details_page.SearchIndexDetailsPage
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    from: `${_routes.SEARCH_INDICES_DETAILS_PATH}/`,
    to: `${_routes.SEARCH_INDICES_DETAILS_PATH}/${_routes.SearchIndexDetailsTabs.DATA}`
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.CREATE_INDEX_PATH,
    component: _create_index_page.CreateIndexPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => {
      application.navigateToApp('elasticsearchStart');
      return null;
    }
  })));
};
exports.SearchIndicesRouter = SearchIndicesRouter;