"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentDocsActionMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../hooks/use_kibana");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecentDocsActionMessage = ({
  indexName
}) => {
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibana)();
  const discoverLocator = share.url.locators.get('DISCOVER_APP_LOCATOR');
  const onClick = async () => {
    await (discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.navigate({
      dataViewSpec: {
        title: indexName
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    color: "subdued",
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "calendar"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchIndices.indexDocuments.recentDocsActionMessage', {
    defaultMessage: 'You are viewing the {pageSize} most recently ingested documents in this index. To see all documents, view in',
    values: {
      pageSize: _constants.DEFAULT_PAGE_SIZE
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick
  }, _i18n.i18n.translate('xpack.searchIndices.indexDocuments.recentDocsActionMessageLink', {
    defaultMessage: 'Discover.'
  }))))));
};
exports.RecentDocsActionMessage = RecentDocsActionMessage;