"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleLinkButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../hooks/use_kibana");
var _use_usage_tracker = require("../hooks/use_usage_tracker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const canOpenConsole = plugin => {
  if (!plugin) return false;
  if (!plugin.isEmbeddedConsoleAvailable || !plugin.openEmbeddedConsole) return false;
  return plugin.isEmbeddedConsoleAvailable();
};
const ConsoleLinkButton = () => {
  const {
    services: {
      console: consolePlugin
    }
  } = (0, _use_kibana.useKibana)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const openConsole = (0, _react.useCallback)(() => {
    usageTracker.click('get_started_in_console');
    if (!canOpenConsole(consolePlugin)) return;
    consolePlugin.openEmbeddedConsole();
  }, [consolePlugin, usageTracker]);
  if (consolePlugin === undefined || consolePlugin.openEmbeddedConsole === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "console",
    color: "primary",
    onClick: openConsole,
    "data-test-subj": "searchHomepageEmbeddedConsoleButton",
    "data-telemetry-id": "searchHomepageEmbeddedConsoleButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.consoleLink.buttonText",
    defaultMessage: "Quickly get started in Console"
  }));
};
exports.ConsoleLinkButton = ConsoleLinkButton;