"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyncJobs = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fetchSyncJobs = async (client, connectorId, from = 0, size = 100, syncJobType = 'all', syncStatus) => {
  const querystring = `from=${from}&size=${size}${connectorId ? '&connector_id=' + connectorId : ''}${syncJobType === 'content' ? '&job_type=full,incremental' : ''}${syncJobType === 'access_control' ? '&job_type=access_control' : ''}${syncStatus ? '&status=' + syncStatus : ''}`;
  const result = await client.transport.request({
    method: 'GET',
    path: `/_connector/_sync_job`,
    querystring
  });
  return {
    _meta: {
      page: {
        from,
        has_more_hits_than_total: result.count > from + size,
        size,
        total: result.count
      }
    },
    data: result.results
  };
};
exports.fetchSyncJobs = fetchSyncJobs;