"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchClusterHasApiKeys = fetchClusterHasApiKeys;
exports.fetchUserStartPrivileges = fetchUserStartPrivileges;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchUserStartPrivileges(client, logger) {
  try {
    var _securityCheck$cluste, _securityCheck$cluste2;
    // relying on manage cluster privilege to check if user can create API keys
    // and can also have permissions for index monitoring
    const securityCheck = await client.security.hasPrivileges({
      cluster: ['manage']
    });
    return (_securityCheck$cluste = securityCheck === null || securityCheck === void 0 ? void 0 : (_securityCheck$cluste2 = securityCheck.cluster) === null || _securityCheck$cluste2 === void 0 ? void 0 : _securityCheck$cluste2.manage) !== null && _securityCheck$cluste !== void 0 ? _securityCheck$cluste : false;
  } catch (e) {
    logger.error(`Error checking user privileges for search API Keys`);
    logger.error(e);
    return false;
  }
}
async function fetchClusterHasApiKeys(client, logger) {
  try {
    const clusterApiKeys = await client.security.queryApiKeys({
      query: {
        term: {
          invalidated: false
        }
      }
    });
    return clusterApiKeys.api_keys.length > 0;
  } catch (e) {
    logger.error(`Error checking cluster for existing valid API keys`);
    logger.error(e);
    return true;
  }
}